﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Script.Serialization;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AnswerJavaScriptConverter : JavaScriptConverter
    {
        private static readonly Type[] _supportedTypes = new[] { typeof(BprAnswer) };

        public override IEnumerable<Type> SupportedTypes
        {
            get { return _supportedTypes; }
        }

        public override object Deserialize(IDictionary<string, object> dictionary, Type type, JavaScriptSerializer serializer)
        {
            if (type == typeof(BprAnswer))
            {
                var obj = new BprAnswer();
                //From data migration:
                if (dictionary.ContainsKey("answerValue"))
                {
                    try
                    {
                        obj.answerValue = serializer.ConvertToType<String>(dictionary["answerValue"]);
                    }
                    catch (Exception)
                    {
                        obj.answerValues = serializer.ConvertToType<String[]>(dictionary["answerValue"]);
                    }
                }
                //From the new version of the registrant portal:
                if (dictionary.ContainsKey("answerValues"))
                {
                    try
                    {
                        obj.answerValues = serializer.ConvertToType<String[]>(dictionary["answerValues"]);
                    }
                    catch (Exception)
                    {
                    }
                }
                if (dictionary.ContainsKey("answerId"))
                {
                    obj.answerId = serializer.ConvertToType<String>(dictionary["answerId"]);
                }

                return obj;
            }

            return null;
        }

        public override IDictionary<string, object> Serialize(object obj, JavaScriptSerializer serializer)
        {
            BprAnswer answer = (BprAnswer)obj;
            IDictionary<string, object> serialized = new Dictionary<string, object>();
            if (answer != null)
            {
                serialized["answerId"] = answer.answerId;
                if (String.IsNullOrEmpty(answer.answerValue))
                {
                    serialized["answerValue"] = answer.answerValues;
                }
                else
                {
                    serialized["answerValue"] = answer.answerValue;
                }
            }
            return serialized;
        }
    }
}